/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.common.util;

import com.ibm.hsc.common.util.HscPasswordMgr;
import com.ibm.websm.etc.EExec;
import com.ibm.websm.etc.EExecResult;
import java.util.StringTokenizer;

public class CreateHSCUser {
    private String _user = null;
    private String _password = null;

    public CreateHSCUser(String string, String string2) {
        this._user = string;
        this._password = string2;
    }

    public static void main(String[] stringArray) {
        CreateHSCUser createHSCUser;
        if (stringArray.length < 2) {
            System.out.println("Sorry, Requires two input arguments...");
            System.exit(0);
        }
        if ((createHSCUser = new CreateHSCUser(stringArray[0], stringArray[1])) != null) {
            createHSCUser.doProcess();
        }
    }

    private void doProcess() {
        System.out.println("Check for existing user ...");
        if (!this.isUserExist()) {
            System.out.println("Creating an user ...");
            if (this.createUser()) {
                System.out.println("Setting password ...");
                if (this.changePassword()) {
                    System.out.println("Check for HSC special user ...");
                    if ("hscroot".equals(this._user)) {
                        System.out.println("Writing password ...");
                        if (HscPasswordMgr.setPassword(this._user, this._password) != 0) {
                            System.out.println("Couldn't write the password ...\nDeleting an user from the system ...");
                            if (this.deleteUser()) {
                                System.out.println("Special User " + this._user + " deleted from system");
                                System.exit(0);
                            }
                        }
                        System.out.println("Created ...");
                        System.exit(0);
                    }
                    System.out.println("Created ...");
                }
            }
        }
    }

    private boolean isUserExist() {
        EExecResult eExecResult = EExec.Exec((String)("grep -c " + this._user + " /etc/passwd | cut -f 1 -d:"));
        if (eExecResult.stdout != null) {
            String string = eExecResult.stdout;
            if (!string.trim().equals("0")) {
                EExecResult eExecResult2 = EExec.Exec((String)("grep  " + this._user + " /etc/passwd | cut -f 1 -d:"));
                if (eExecResult2.stdout != null) {
                    StringTokenizer stringTokenizer = new StringTokenizer(eExecResult2.stdout, "\n");
                    while (stringTokenizer.hasMoreTokens()) {
                        String string2 = stringTokenizer.nextToken();
                        if (!string2.trim().equals(this._user)) continue;
                        String string3 = "User '" + this._user + "' already exists or it could be a reserved user";
                        System.out.println(string3);
                        EExecResult eExecResult3 = EExec.Exec((String)("/usr/bin/perl /opt/hsc/bin/rmcadduser " + this._user));
                        if (eExecResult3.stdout != null) {
                            System.out.println("User " + this._user + " is added in ctrmc.acls...");
                            EExecResult eExecResult4 = EExec.Exec((String)"/usr/bin/refresh -s ctrmc");
                        }
                        return true;
                    }
                }
            }
            return false;
        }
        return false;
    }

    private boolean createUser() {
        try {
            String string = "/opt/hsc/bin/HSCUserConf -c " + this._user + " 'HSC Super User' HSC_Sys_Prog HSC_Sys_Prog -rmcadd";
            EExecResult eExecResult = EExec.Exec((String)string);
            return eExecResult.rc == 0;
        }
        catch (Exception exception) {
            System.out.println("Error in createUser() ...\n");
            exception.printStackTrace();
            return false;
        }
    }

    private boolean deleteUser() {
        try {
            String string = "/opt/hsc/bin/HSCUserConf -d " + this._user + " -rmcdelete";
            EExecResult eExecResult = EExec.Exec((String)string);
            return eExecResult.rc == 0;
        }
        catch (Exception exception) {
            System.out.println("Error in deleteUser() ...\n");
            exception.printStackTrace();
            return false;
        }
    }

    private boolean changePassword() {
        try {
            String string = "/opt/hsc/bin/HSCUserConf -p " + this._user + " " + this._password;
            EExecResult eExecResult = EExec.Exec((String)string);
            return eExecResult.rc == 0;
        }
        catch (Exception exception) {
            System.out.println("Error in changePassword() ...\n");
            exception.printStackTrace();
            return false;
        }
    }
}

